/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.feature;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.HoverEvent;

public class KeybindFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "keybindings";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<keybind;")) {
                return false;
            }
            String keybindKey = nibbler.consumeUntil('>');
            if (keybindKey == null) {
                return false;
            }
            Optional<KeyBinding> binding = Arrays.stream(Minecraft.func_71410_x().field_71474_y.field_74324_K).filter($ -> $.func_151464_g().equals(keybindKey)).findAny();
            if (binding.isEmpty()) {
                return false;
            }
            tokens.add(new KeybindToken(keybindKey, binding.get()));
            return true;
        }, '<');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, keybindToken, tokens) -> new KeybindNode(keybindToken.binding), (token, tokens) -> token instanceof KeybindToken ? (KeybindToken)token : null);
    }

    private static class KeybindToken
    extends Lexer.Token {
        public final KeyBinding binding;

        public KeybindToken(String content, KeyBinding binding) {
            super(content);
            this.binding = binding;
        }
    }

    private static class KeybindNode
    extends Parser.Node {
        private final KeyBinding binding;

        public KeybindNode(KeyBinding binding) {
            this.binding = binding;
        }

        @Override
        public void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitStyle(style -> style.func_240712_a_(TextFormatting.GOLD).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("text.lavender.keybind_tooltip", new Object[]{new TranslationTextComponent(this.binding.func_151466_e()), new TranslationTextComponent(this.binding.func_151464_g())}))));
            compiler.visitText(I18n.func_135052_a((String)this.binding.func_197982_m(), (Object[])new Object[0]));
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
            compiler.visitStyleEnd();
        }
    }
}

