/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.feature;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import org.jetbrains.annotations.NotNull;

public class LinkFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "links";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken(Lexer.Token.lexFromChar(OpenLinkToken::new), '[');
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.tryConsume('(')) {
                return false;
            }
            String link = nibbler.consumeUntil(')');
            if (link == null) {
                return false;
            }
            tokens.add(new CloseLinkToken(link));
            return true;
        }, ']');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, left, tokens) -> {
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, CloseLinkToken.class);
            Object r = tokens.peek();
            if (r instanceof CloseLinkToken) {
                tokens.nibble();
                return new Parser.FormattingNode(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, ((CloseLinkToken)r).link)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(((CloseLinkToken)r).link))).m_131140_(ChatFormatting.BLUE)).addChild(content);
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left.content());
        }, (token, tokens) -> token instanceof OpenLinkToken ? (OpenLinkToken)token : null);
    }

    private static final class OpenLinkToken
    extends Lexer.Token {
        public OpenLinkToken() {
            super("[");
        }
    }

    private static final class CloseLinkToken
    extends Lexer.Token {
        @NotNull
        public final String link;

        public CloseLinkToken(@NotNull String link) {
            super("](" + link + ")");
            this.link = link;
        }
    }
}

