/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.feature;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;

public class BlockQuoteFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "block_quotes";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            String brackets = nibbler.consumeUntilEndOr(c -> c != '>');
            if (!nibbler.tryConsume(' ')) {
                return false;
            }
            tokens.add(new QuotationToken(brackets.length()));
            return true;
        }, '>');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, current, tokens) -> new QuotationNode().addChild(parser.parseUntil(tokens, $ -> $.isBoundary() && (!($ instanceof QuotationToken) || ((QuotationToken)$).depth < current.depth), $ -> $ instanceof QuotationToken && ((QuotationToken)$).depth == current.depth)), (token, tokens) -> token instanceof QuotationToken && (tokens.peek(-2) == null || tokens.peek(-2) instanceof Lexer.NewlineToken) ? (QuotationToken)token : null);
    }

    private static final class QuotationToken
    extends Lexer.Token {
        public final int depth;

        public QuotationToken(int depth) {
            super(">".repeat(depth) + " ");
            this.depth = depth;
        }

        @Override
        public boolean isBoundary() {
            return true;
        }
    }

    private static class QuotationNode
    extends Parser.Node {
        private QuotationNode() {
        }

        @Override
        protected void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitBlockQuote();
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
            compiler.visitBlockQuoteEnd();
        }
    }
}

