/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.feature;

import com.google.common.collect.ImmutableMap;
import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class ColorFeature
implements MarkdownFeature {
    private static final Map<String, ChatFormatting> FORMATTING_COLORS = (Map)Stream.of(ChatFormatting.values()).filter(ChatFormatting::isColor).collect(ImmutableMap.toImmutableMap(formatting -> formatting.getName().toLowerCase(Locale.ROOT), Function.identity()));

    @Override
    public String name() {
        return "colors";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            nibbler.skip();
            if (!nibbler.hasNext()) {
                return false;
            }
            if (nibbler.peek() == '}') {
                nibbler.skip();
                tokens.add(new CloseColorToken());
            } else if (nibbler.peek() == '#') {
                nibbler.skip();
                String color = nibbler.consumeUntil('}');
                if (color == null) {
                    return false;
                }
                if (!color.matches("[0-9a-fA-F]{6}")) {
                    return false;
                }
                tokens.add(new OpenColorToken("{#" + color + "}", style -> style.withColor(Integer.parseInt(color, 16))));
            } else {
                String color = nibbler.consumeUntil('}');
                if (color == null) {
                    return false;
                }
                if (!FORMATTING_COLORS.containsKey(color)) {
                    return false;
                }
                tokens.add(new OpenColorToken("{" + color + "}", style -> style.applyFormat(FORMATTING_COLORS.get(color))));
            }
            return true;
        }, '{');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, left, tokens) -> {
            int pointer = tokens.pointer();
            Parser.Node content = parser.parseUntil(tokens, CloseColorToken.class);
            if (tokens.peek() instanceof CloseColorToken) {
                tokens.nibble();
                return new Parser.FormattingNode(left.style).addChild(content);
            }
            tokens.setPointer(pointer);
            return new Parser.TextNode(left.content());
        }, (token, tokens) -> token instanceof OpenColorToken ? (OpenColorToken)token : null);
    }

    private static final class OpenColorToken
    extends Lexer.Token {
        @NotNull
        public final UnaryOperator<Style> style;

        public OpenColorToken(String content, @NotNull UnaryOperator<Style> style) {
            super(content);
            this.style = style;
        }
    }

    private static final class CloseColorToken
    extends Lexer.Token {
        private CloseColorToken() {
            super("{}");
        }
    }
}

