/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.util;

import java.util.function.Predicate;
import net.minecraft.CharPredicate;
import org.jetbrains.annotations.Nullable;

public class StringNibbler {
    public final String string;
    private int cursor;

    public StringNibbler(String string) {
        this.string = string;
    }

    public int cursor() {
        return this.cursor;
    }

    public char peek() {
        return this.string.charAt(this.cursor);
    }

    public void skip() {
        this.skip(1);
    }

    public void skip(int count) {
        this.cursor += count;
    }

    @Nullable
    public Character next() {
        return this.cursor < this.string.length() ? Character.valueOf(this.string.charAt(this.cursor++)) : null;
    }

    public String consumed() {
        return this.string.substring(0, this.cursor);
    }

    public boolean hasNext() {
        return this.cursor < this.string.length();
    }

    @Nullable
    public Character peekOffset(int offset) {
        int charIndex = this.cursor + offset;
        return charIndex >= 0 && charIndex < this.string.length() ? Character.valueOf(this.string.charAt(charIndex)) : null;
    }

    @Nullable
    public String consumeEscapedString(char terminator, boolean allowUnterminated) {
        StringBuilder read = new StringBuilder();
        while (this.hasNext()) {
            char next = this.next().charValue();
            if (next == '\\' && this.expect(0, terminator)) {
                this.skip();
                read.append(terminator);
                continue;
            }
            if (next == terminator) {
                return read.toString();
            }
            read.append(next);
        }
        return allowUnterminated ? read.toString() : null;
    }

    @Nullable
    public String consumeUntil(char delimiter) {
        return this.consumeUntil(delimiter, true);
    }

    @Nullable
    public String consumeUntil(char delimiter, boolean skipDelimiter) {
        StringBuilder read = new StringBuilder();
        if (this.tryMatch($ -> {
            while (this.hasNext()) {
                if (this.peek() == delimiter) {
                    if (skipDelimiter) {
                        this.skip();
                    }
                    return true;
                }
                read.append(this.next());
            }
            return false;
        })) {
            return read.toString();
        }
        return null;
    }

    public String consumeUntilEndOr(CharPredicate until) {
        StringBuilder read = new StringBuilder();
        while (this.hasNext() && !until.test(this.peek())) {
            read.append(this.next());
        }
        return read.toString();
    }

    public boolean expect(int offset, char expect) {
        int charIndex = this.cursor + offset;
        return charIndex >= 0 && charIndex < this.string.length() && this.string.charAt(charIndex) == expect;
    }

    public boolean tryConsume(char consume) {
        return this.tryMatch($ -> {
            Character next = this.next();
            return next != null && next.charValue() == consume;
        });
    }

    public boolean tryConsume(String consume) {
        return this.tryMatch(stringNibbler -> {
            for (int i = 0; i < consume.length(); ++i) {
                Character next = this.next();
                if (next != null && next.charValue() == consume.charAt(i)) continue;
                return false;
            }
            return true;
        });
    }

    public boolean tryMatch(Predicate<StringNibbler> matcher) {
        int cursorPos = this.cursor;
        if (!matcher.test(this)) {
            this.cursor = cursorPos;
            return false;
        }
        return true;
    }
}

