/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.compiler;

import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import dev.jab125.lavendermd.util.TextBuilder;
import java.util.OptionalInt;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class TextCompiler
implements MarkdownCompiler<Component> {
    private final TextBuilder builder = new TextBuilder();
    private final int assumedOutputWidth;
    private int quoteDepth = 0;
    private int listDepth = 0;

    public TextCompiler() {
        this(50);
    }

    public TextCompiler(int assumedOutputWidth) {
        this.assumedOutputWidth = assumedOutputWidth;
    }

    @Override
    public void visitText(String text) {
        if (this.quoteDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(this.quoteMarker());
            } else {
                for (String line : text.split("\n")) {
                    this.builder.append(this.quoteMarker().append((Component)Component.literal((String)line)));
                }
            }
        } else if (this.listDepth != 0 && text.contains("\n")) {
            if (text.equals("\n")) {
                this.builder.append(Component.literal((String)("\n   " + "  ".repeat(this.listDepth - 1))));
            } else {
                String[] lines = text.split("\n");
                for (int i = 0; i < lines.length; ++i) {
                    this.builder.append(Component.literal((String)((i > 0 ? "\n   " : "   ") + "  ".repeat(this.listDepth - 1))).append((Component)Component.literal((String)lines[i])));
                }
            }
        } else {
            this.builder.append(Component.literal((String)text));
        }
    }

    @Override
    public void visitStyle(UnaryOperator<Style> style) {
        this.builder.pushStyle(style);
    }

    @Override
    public void visitStyleEnd() {
        this.builder.popStyle();
    }

    @Override
    public void visitBlockQuote() {
        ++this.quoteDepth;
        this.builder.append(this.quoteMarker());
        this.builder.pushStyle(style -> style.withColor(ChatFormatting.GRAY).withItalic(Boolean.valueOf(true)));
    }

    @Override
    public void visitBlockQuoteEnd() {
        this.builder.popStyle();
        --this.quoteDepth;
        if (this.quoteDepth > 0) {
            this.builder.append(this.quoteMarker());
        } else {
            this.builder.append(Component.literal((String)"\n"));
        }
    }

    private MutableComponent quoteMarker() {
        return Component.literal((String)("\n >" + ">".repeat(this.quoteDepth) + " ")).withStyle(ChatFormatting.DARK_GRAY);
    }

    @Override
    public void visitHorizontalRule() {
        this.builder.append(Component.literal((String)"-".repeat(this.assumedOutputWidth)).withStyle(ChatFormatting.DARK_GRAY));
    }

    @Override
    public void visitImage(ResourceLocation image, String description, boolean fit) {
        this.builder.append(Component.literal((String)("[" + description + "]")).withStyle(ChatFormatting.YELLOW));
    }

    @Override
    public void visitListItem(OptionalInt ordinal) {
        String listPrefix;
        String string = listPrefix = ordinal.isPresent() ? " " + ordinal.getAsInt() + ". " : " \u2022 ";
        if (this.listDepth > 0) {
            this.builder.append(Component.literal((String)("\n" + "   ".repeat(this.listDepth) + listPrefix)));
        } else {
            this.builder.append(Component.literal((String)listPrefix));
        }
        ++this.listDepth;
    }

    @Override
    public void visitListItemEnd() {
        --this.listDepth;
        if (this.listDepth > 0) {
            this.builder.append(Component.literal((String)"   ".repeat(this.listDepth)));
        } else {
            this.builder.append(Component.literal((String)"\n"));
        }
    }

    @Override
    public Component compile() {
        return this.builder.build();
    }

    @Override
    public String name() {
        return "lavender_builtin_text";
    }
}

