/*
 * Decompiled with CFR 0.152.
 */
package dev.jab125.lavendermd.feature;

import dev.jab125.lavendermd.Lexer;
import dev.jab125.lavendermd.MarkdownFeature;
import dev.jab125.lavendermd.Parser;
import dev.jab125.lavendermd.compiler.MarkdownCompiler;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;

public class KeybindFeature
implements MarkdownFeature {
    @Override
    public String name() {
        return "keybindings";
    }

    @Override
    public boolean supportsCompiler(MarkdownCompiler<?> compiler) {
        return true;
    }

    @Override
    public void registerTokens(MarkdownFeature.TokenRegistrar registrar) {
        registrar.registerToken((nibbler, tokens) -> {
            if (!nibbler.tryConsume("<keybind;")) {
                return false;
            }
            String keybindKey = nibbler.consumeUntil('>');
            if (keybindKey == null) {
                return false;
            }
            Optional<KeyMapping> binding = Arrays.stream(Minecraft.getInstance().options.keyMappings).filter($ -> $.getName().equals(keybindKey)).findAny();
            if (binding.isEmpty()) {
                return false;
            }
            tokens.add(new KeybindToken(keybindKey, binding.get()));
            return true;
        }, '<');
    }

    @Override
    public void registerNodes(MarkdownFeature.NodeRegistrar registrar) {
        registrar.registerNode((parser, keybindToken, tokens) -> new KeybindNode(keybindToken.binding), (token, tokens) -> token instanceof KeybindToken ? (KeybindToken)token : null);
    }

    private static class KeybindToken
    extends Lexer.Token {
        public final KeyMapping binding;

        public KeybindToken(String content, KeyMapping binding) {
            super(content);
            this.binding = binding;
        }
    }

    private static class KeybindNode
    extends Parser.Node {
        private final KeyMapping binding;

        public KeybindNode(KeyMapping binding) {
            this.binding = binding;
        }

        @Override
        public void visitStart(MarkdownCompiler<?> compiler) {
            compiler.visitStyle(style -> style.withColor(ChatFormatting.GOLD).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"text.lavender.keybind_tooltip", (Object[])new Object[]{Component.translatable((String)this.binding.getCategory()), Component.translatable((String)this.binding.getName())}))));
            compiler.visitText(I18n.get((String)this.binding.saveString(), (Object[])new Object[0]));
        }

        @Override
        protected void visitEnd(MarkdownCompiler<?> compiler) {
            compiler.visitStyleEnd();
        }
    }
}

